/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlackstoneReplaceProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockAgeProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.LavaSubmergedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.slf4j.Logger;

public class RuinedPortalPiece
extends TemplateStructurePiece {
    private static final Logger f_72650_ = LogUtils.getLogger();
    private static final float f_163130_ = 0.3f;
    private static final float f_163131_ = 0.07f;
    private static final float f_163132_ = 0.2f;
    private static final float f_163133_ = 0.2f;
    private final VerticalPlacement f_72654_;
    private final Properties f_72655_;

    public RuinedPortalPiece(StructureManager p_163138_, BlockPos p_163139_, VerticalPlacement p_163140_, Properties p_163141_, ResourceLocation p_163142_, StructureTemplate p_163143_, Rotation p_163144_, Mirror p_163145_, BlockPos p_163146_) {
        super(StructurePieceType.f_210104_, 0, p_163138_, p_163142_, p_163142_.toString(), RuinedPortalPiece.m_163154_(p_163145_, p_163144_, p_163140_, p_163146_, p_163141_), p_163139_);
        this.f_72654_ = p_163140_;
        this.f_72655_ = p_163141_;
    }

    public RuinedPortalPiece(StructureManager p_192446_, CompoundTag p_192447_) {
        super(StructurePieceType.f_210104_, p_192447_, p_192446_, p_192466_ -> RuinedPortalPiece.m_192459_(p_192446_, p_192447_, p_192466_));
        this.f_72654_ = VerticalPlacement.m_72782_(p_192447_.m_128461_("VerticalPlacement"));
        this.f_72655_ = (Properties)Properties.f_72735_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_192447_.m_128423_("Properties"))).getOrThrow(true, arg_0 -> ((Logger)f_72650_).error(arg_0));
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext p_192457_, CompoundTag p_192458_) {
        super.m_183620_(p_192457_, p_192458_);
        p_192458_.m_128359_("Rotation", this.f_73657_.m_74404_().name());
        p_192458_.m_128359_("Mirror", this.f_73657_.m_74401_().name());
        p_192458_.m_128359_("VerticalPlacement", this.f_72654_.m_72779_());
        Properties.f_72735_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.f_72655_).resultOrPartial(arg_0 -> ((Logger)f_72650_).error(arg_0)).ifPresent(p_163169_ -> p_192458_.m_128365_("Properties", (Tag)p_163169_));
    }

    private static StructurePlaceSettings m_192459_(StructureManager p_192460_, CompoundTag p_192461_, ResourceLocation p_192462_) {
        StructureTemplate $$3 = p_192460_.m_74341_(p_192462_);
        BlockPos $$4 = new BlockPos($$3.m_163801_().m_123341_() / 2, 0, $$3.m_163801_().m_123343_() / 2);
        return RuinedPortalPiece.m_163154_(Mirror.valueOf(p_192461_.m_128461_("Mirror")), Rotation.valueOf(p_192461_.m_128461_("Rotation")), VerticalPlacement.m_72782_(p_192461_.m_128461_("VerticalPlacement")), $$4, (Properties)Properties.f_72735_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_192461_.m_128423_("Properties"))).getOrThrow(true, arg_0 -> ((Logger)f_72650_).error(arg_0)));
    }

    private static StructurePlaceSettings m_163154_(Mirror p_163155_, Rotation p_163156_, VerticalPlacement p_163157_, BlockPos p_163158_, Properties p_163159_) {
        BlockIgnoreProcessor $$5 = p_163159_.f_72738_ ? BlockIgnoreProcessor.f_74046_ : BlockIgnoreProcessor.f_74048_;
        ArrayList $$6 = Lists.newArrayList();
        $$6.add(RuinedPortalPiece.m_72685_(Blocks.f_50074_, 0.3f, Blocks.f_50016_));
        $$6.add(RuinedPortalPiece.m_163160_(p_163157_, p_163159_));
        if (!p_163159_.f_72736_) {
            $$6.add(RuinedPortalPiece.m_72685_(Blocks.f_50134_, 0.07f, Blocks.f_50450_));
        }
        StructurePlaceSettings $$7 = new StructurePlaceSettings().m_74379_(p_163156_).m_74377_(p_163155_).m_74385_(p_163158_).m_74383_($$5).m_74383_(new RuleProcessor($$6)).m_74383_(new BlockAgeProcessor(p_163159_.f_72737_)).m_74383_(new ProtectedBlockProcessor(BlockTags.f_144287_)).m_74383_(new LavaSubmergedBlockProcessor());
        if (p_163159_.f_72741_) {
            $$7.m_74383_(BlackstoneReplaceProcessor.f_73994_);
        }
        return $$7;
    }

    private static ProcessorRule m_163160_(VerticalPlacement p_163161_, Properties p_163162_) {
        if (p_163161_ == VerticalPlacement.ON_OCEAN_FLOOR) {
            return RuinedPortalPiece.m_72689_(Blocks.f_49991_, Blocks.f_50450_);
        }
        if (p_163162_.f_72736_) {
            return RuinedPortalPiece.m_72689_(Blocks.f_49991_, Blocks.f_50134_);
        }
        return RuinedPortalPiece.m_72685_(Blocks.f_49991_, 0.2f, Blocks.f_50450_);
    }

    @Override
    public void m_183269_(WorldGenLevel p_192449_, StructureFeatureManager p_192450_, ChunkGenerator p_192451_, Random p_192452_, BoundingBox p_192453_, ChunkPos p_192454_, BlockPos p_192455_) {
        BoundingBox $$7 = this.f_73656_.m_74633_(this.f_73657_, this.f_73658_);
        if (!p_192453_.m_71051_($$7.m_162394_())) {
            return;
        }
        p_192453_.m_162386_($$7);
        super.m_183269_(p_192449_, p_192450_, p_192451_, p_192452_, p_192453_, p_192454_, p_192455_);
        this.m_72719_(p_192452_, p_192449_);
        this.m_72703_(p_192452_, p_192449_);
        if (this.f_72655_.f_72740_ || this.f_72655_.f_72739_) {
            BlockPos.m_121919_(this.m_73547_()).forEach(p_163166_ -> {
                if (this.f_72655_.f_72740_) {
                    this.m_72706_(p_192452_, p_192449_, (BlockPos)p_163166_);
                }
                if (this.f_72655_.f_72739_) {
                    this.m_72722_(p_192452_, p_192449_, (BlockPos)p_163166_);
                }
            });
        }
    }

    @Override
    protected void m_7756_(String p_72698_, BlockPos p_72699_, ServerLevelAccessor p_72700_, Random p_72701_, BoundingBox p_72702_) {
    }

    private void m_72706_(Random p_72707_, LevelAccessor p_72708_, BlockPos p_72709_) {
        BlockState $$3 = p_72708_.m_8055_(p_72709_);
        if ($$3.m_60795_() || $$3.m_60713_(Blocks.f_50191_)) {
            return;
        }
        Direction $$4 = RuinedPortalPiece.m_163580_(p_72707_);
        BlockPos $$5 = p_72709_.m_142300_($$4);
        BlockState $$6 = p_72708_.m_8055_($$5);
        if (!$$6.m_60795_()) {
            return;
        }
        if (!Block.m_49918_($$3.m_60812_(p_72708_, p_72709_), $$4)) {
            return;
        }
        BooleanProperty $$7 = VineBlock.m_57883_($$4.m_122424_());
        p_72708_.m_7731_($$5, (BlockState)Blocks.f_50191_.m_49966_().m_61124_($$7, true), 3);
    }

    private void m_72722_(Random p_72723_, LevelAccessor p_72724_, BlockPos p_72725_) {
        if (p_72723_.nextFloat() < 0.5f && p_72724_.m_8055_(p_72725_).m_60713_(Blocks.f_50134_) && p_72724_.m_8055_(p_72725_.m_7494_()).m_60795_()) {
            p_72724_.m_7731_(p_72725_.m_7494_(), (BlockState)Blocks.f_50053_.m_49966_().m_61124_(LeavesBlock.f_54419_, true), 3);
        }
    }

    private void m_72703_(Random p_72704_, LevelAccessor p_72705_) {
        for (int $$2 = this.f_73383_.m_162395_() + 1; $$2 < this.f_73383_.m_162399_(); ++$$2) {
            for (int $$3 = this.f_73383_.m_162398_() + 1; $$3 < this.f_73383_.m_162401_(); ++$$3) {
                BlockPos $$4 = new BlockPos($$2, this.f_73383_.m_162396_(), $$3);
                if (!p_72705_.m_8055_($$4).m_60713_(Blocks.f_50134_)) continue;
                this.m_72727_(p_72704_, p_72705_, $$4.m_7495_());
            }
        }
    }

    private void m_72727_(Random p_72728_, LevelAccessor p_72729_, BlockPos p_72730_) {
        BlockPos.MutableBlockPos $$3 = p_72730_.m_122032_();
        this.m_72731_(p_72728_, p_72729_, $$3);
        for (int $$4 = 8; $$4 > 0 && p_72728_.nextFloat() < 0.5f; --$$4) {
            $$3.m_122173_(Direction.DOWN);
            this.m_72731_(p_72728_, p_72729_, $$3);
        }
    }

    private void m_72719_(Random p_72720_, LevelAccessor p_72721_) {
        boolean $$2 = this.f_72654_ == VerticalPlacement.ON_LAND_SURFACE || this.f_72654_ == VerticalPlacement.ON_OCEAN_FLOOR;
        BlockPos $$3 = this.f_73383_.m_162394_();
        int $$4 = $$3.m_123341_();
        int $$5 = $$3.m_123343_();
        float[] $$6 = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int $$7 = $$6.length;
        int $$8 = (this.f_73383_.m_71056_() + this.f_73383_.m_71058_()) / 2;
        int $$9 = p_72720_.nextInt(Math.max(1, 8 - $$8 / 2));
        int $$10 = 3;
        BlockPos.MutableBlockPos $$11 = BlockPos.f_121853_.m_122032_();
        for (int $$12 = $$4 - $$7; $$12 <= $$4 + $$7; ++$$12) {
            for (int $$13 = $$5 - $$7; $$13 <= $$5 + $$7; ++$$13) {
                int $$14 = Math.abs($$12 - $$4) + Math.abs($$13 - $$5);
                int $$15 = Math.max(0, $$14 + $$9);
                if ($$15 >= $$7) continue;
                float $$16 = $$6[$$15];
                if (!(p_72720_.nextDouble() < (double)$$16)) continue;
                int $$17 = RuinedPortalPiece.m_72669_(p_72721_, $$12, $$13, this.f_72654_);
                int $$18 = $$2 ? $$17 : Math.min(this.f_73383_.m_162396_(), $$17);
                $$11.m_122178_($$12, $$18, $$13);
                if (Math.abs($$18 - this.f_73383_.m_162396_()) > 3 || !this.m_72674_(p_72721_, $$11)) continue;
                this.m_72731_(p_72720_, p_72721_, $$11);
                if (this.f_72655_.f_72739_) {
                    this.m_72722_(p_72720_, p_72721_, $$11);
                }
                this.m_72727_(p_72720_, p_72721_, (BlockPos)$$11.m_7495_());
            }
        }
    }

    private boolean m_72674_(LevelAccessor p_72675_, BlockPos p_72676_) {
        BlockState $$2 = p_72675_.m_8055_(p_72676_);
        return !$$2.m_60713_(Blocks.f_50016_) && !$$2.m_60713_(Blocks.f_50080_) && !$$2.m_204336_(BlockTags.f_144287_) && (this.f_72654_ == VerticalPlacement.IN_NETHER || !$$2.m_60713_(Blocks.f_49991_));
    }

    private void m_72731_(Random p_72732_, LevelAccessor p_72733_, BlockPos p_72734_) {
        if (!this.f_72655_.f_72736_ && p_72732_.nextFloat() < 0.07f) {
            p_72733_.m_7731_(p_72734_, Blocks.f_50450_.m_49966_(), 3);
        } else {
            p_72733_.m_7731_(p_72734_, Blocks.f_50134_.m_49966_(), 3);
        }
    }

    private static int m_72669_(LevelAccessor p_72670_, int p_72671_, int p_72672_, VerticalPlacement p_72673_) {
        return p_72670_.m_6924_(RuinedPortalPiece.m_72692_(p_72673_), p_72671_, p_72672_) - 1;
    }

    public static Heightmap.Types m_72692_(VerticalPlacement p_72693_) {
        return p_72693_ == VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
    }

    private static ProcessorRule m_72685_(Block p_72686_, float p_72687_, Block p_72688_) {
        return new ProcessorRule(new RandomBlockMatchTest(p_72686_, p_72687_), AlwaysTrueTest.f_73954_, p_72688_.m_49966_());
    }

    private static ProcessorRule m_72689_(Block p_72690_, Block p_72691_) {
        return new ProcessorRule(new BlockMatchTest(p_72690_), AlwaysTrueTest.f_73954_, p_72691_.m_49966_());
    }

    public static final class VerticalPlacement
    extends Enum<VerticalPlacement> {
        public static final /* enum */ VerticalPlacement ON_LAND_SURFACE = new VerticalPlacement("on_land_surface");
        public static final /* enum */ VerticalPlacement PARTLY_BURIED = new VerticalPlacement("partly_buried");
        public static final /* enum */ VerticalPlacement ON_OCEAN_FLOOR = new VerticalPlacement("on_ocean_floor");
        public static final /* enum */ VerticalPlacement IN_MOUNTAIN = new VerticalPlacement("in_mountain");
        public static final /* enum */ VerticalPlacement UNDERGROUND = new VerticalPlacement("underground");
        public static final /* enum */ VerticalPlacement IN_NETHER = new VerticalPlacement("in_nether");
        private static final Map<String, VerticalPlacement> f_72771_;
        private final String f_72772_;
        private static final /* synthetic */ VerticalPlacement[] $VALUES;

        public static VerticalPlacement[] values() {
            return (VerticalPlacement[])$VALUES.clone();
        }

        public static VerticalPlacement valueOf(String p_72785_) {
            return Enum.valueOf(VerticalPlacement.class, p_72785_);
        }

        private VerticalPlacement(String p_72778_) {
            this.f_72772_ = p_72778_;
        }

        public String m_72779_() {
            return this.f_72772_;
        }

        public static VerticalPlacement m_72782_(String p_72783_) {
            return f_72771_.get(p_72783_);
        }

        private static /* synthetic */ VerticalPlacement[] m_163186_() {
            return new VerticalPlacement[]{ON_LAND_SURFACE, PARTLY_BURIED, ON_OCEAN_FLOOR, IN_MOUNTAIN, UNDERGROUND, IN_NETHER};
        }

        static {
            $VALUES = VerticalPlacement.m_163186_();
            f_72771_ = Arrays.stream(VerticalPlacement.values()).collect(Collectors.toMap(VerticalPlacement::m_72779_, p_72781_ -> p_72781_));
        }
    }

    public static class Properties {
        public static final Codec<Properties> f_72735_ = RecordCodecBuilder.create(p_72752_ -> p_72752_.group((App)Codec.BOOL.fieldOf("cold").forGetter(p_163185_ -> p_163185_.f_72736_), (App)Codec.FLOAT.fieldOf("mossiness").forGetter(p_163183_ -> Float.valueOf(p_163183_.f_72737_)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(p_163181_ -> p_163181_.f_72738_), (App)Codec.BOOL.fieldOf("overgrown").forGetter(p_163179_ -> p_163179_.f_72739_), (App)Codec.BOOL.fieldOf("vines").forGetter(p_163177_ -> p_163177_.f_72740_), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(p_163175_ -> p_163175_.f_72741_)).apply((Applicative)p_72752_, Properties::new));
        public boolean f_72736_;
        public float f_72737_ = 0.2f;
        public boolean f_72738_;
        public boolean f_72739_;
        public boolean f_72740_;
        public boolean f_72741_;

        public Properties() {
        }

        public Properties(boolean p_72745_, float p_72746_, boolean p_72747_, boolean p_72748_, boolean p_72749_, boolean p_72750_) {
            this.f_72736_ = p_72745_;
            this.f_72737_ = p_72746_;
            this.f_72738_ = p_72747_;
            this.f_72739_ = p_72748_;
            this.f_72740_ = p_72749_;
            this.f_72741_ = p_72750_;
        }
    }
}

